# 🚀 LinkedIn AI Agent - Standalone Version

> **Professional LinkedIn automation powered by AI** - Generate, schedule, and auto-post engaging LinkedIn content with intelligent automation.

## ✨ Features

### 🤖 **AI Content Generation**
- **Smart Post Creation** - Generate engaging LinkedIn posts using OpenAI GPT
- **Topic-Based Generation** - Create content around specific topics and themes
- **Professional Tone** - Maintains appropriate LinkedIn professional standards
- **Hashtag Optimization** - Automatically includes relevant hashtags

### 📅 **Advanced Scheduling**
- **Future Post Scheduling** - Schedule posts for optimal engagement times
- **Bulk Scheduling** - Plan your content calendar weeks in advance
- **Smart Timing** - AI suggests best posting times based on your audience
- **Calendar Integration** - View and manage all scheduled posts

### 🔄 **Intelligent Auto-Posting**
- **Automated Content Creation** - Generate and post content automatically
- **Customizable Intervals** - Set posting frequency (daily, weekly, custom)
- **Topic Rotation** - Cycle through different content themes
- **Safety Controls** - Manual review options and content filters

### 📊 **Analytics & Insights**
- **Post Performance Tracking** - Monitor engagement and reach
- **Content Analytics** - Understand what content performs best
- **Growth Metrics** - Track follower growth and engagement trends
- **Weekly/Monthly Reports** - Automated performance summaries

### 🎨 **Rich Media Support**
- **Multi-Image Posts** - Create carousel posts with 2-20 images
- **Document Sharing** - Post PDFs, PowerPoints, and Word documents
- **Media Upload** - Drag-and-drop file uploads with preview
- **Format Optimization** - Automatic file optimization for LinkedIn

### 🔐 **Enterprise-Grade Security**
- **OAuth 2.0 Authentication** - Secure LinkedIn integration
- **Token Management** - Automatic token refresh and security
- **Local Data Storage** - Your data stays on your machine
- **Privacy First** - No data sent to external servers

## 🛠️ Quick Setup

### **Prerequisites**
- **Node.js 18+** - [Download here](https://nodejs.org/)
- **LinkedIn Developer Account** - [Sign up here](https://www.linkedin.com/developers/)
- **OpenAI API Key** (optional) - [Get one here](https://platform.openai.com/)

### **1️⃣ Extract & Install**

```bash
# Extract the downloaded zip file
unzip linkedin-ai-agent.zip
cd linkedin-ai-agent

# Install dependencies
npm install
```

### **2️⃣ LinkedIn App Setup**

1. **Go to LinkedIn Developer Portal**
   - Visit: [https://www.linkedin.com/developers/apps](https://www.linkedin.com/developers/apps)
   - Click "Create App"

2. **App Configuration**
   - **App Name**: "My LinkedIn AI Agent"
   - **LinkedIn Page**: Select your company page or personal
   - **App Use**: Select "Content management" and "Marketing"

3. **Enable Required Products**
   - Go to "Products" tab
   - Enable: "Sign In with LinkedIn using OpenID Connect"
   - Enable: "Share on LinkedIn"
   - Enable: "Marketing Developer Platform" (for advanced features)

4. **Configure OAuth**
   - Go to "Auth" tab
   - Add Authorized Redirect URL: `http://localhost:3000/api/auth/linkedin/callback`
   - Note your **Client ID** and **Client Secret**

### **3️⃣ Environment Configuration**

```bash
# Copy environment template
cp .env.example .env.local

# Edit the environment file
nano .env.local  # or use your preferred editor
```

**Update these values in `.env.local`:**

```env
LINKEDIN_CLIENT_ID=your-linkedin-client-id
LINKEDIN_CLIENT_SECRET=your-linkedin-client-secret
LINKEDIN_REDIRECT_URI=http://localhost:3000/api/auth/linkedin/callback
BASE_URL=http://localhost:3000
NEXTAUTH_SECRET=your-random-32-character-secret
```

### **4️⃣ Start the Application**

```bash
# Development mode
npm run dev

# Production mode
npm run build
npm start
```

🎉 **Open [http://localhost:3000](http://localhost:3000)** to access your LinkedIn AI Agent!

## 🎯 Usage Guide

### **First Time Setup**

1. **Connect LinkedIn**
   - Click "Connect LinkedIn" in the left panel
   - Authorize the application
   - Verify your connection

2. **Configure OpenAI** (Optional)
   - Click "Configure OpenAI" in the left panel
   - Enter your OpenAI API key
   - Test the connection

3. **Generate Your First Post**
   - Enter a topic in the content generation section
   - Click "Generate Content"
   - Review and edit as needed
   - Click "Post Now" or schedule for later

## 🚀 Deployment

See `docs/deployment.md` for detailed deployment guides for various platforms.

## 📜 License

MIT License - see `LICENSE` file for details.

---

**🚀 Happy posting!** Your LinkedIn audience is waiting for amazing content.